#include "StdAfx.h"
#include "ListViewEstrellas.h"
#include "resource.h"

ListViewEstrellas::ListViewEstrellas(void) : DListView(), _UltimoItem(-1) {
}


// Funcin que crea el listview con dos columnas
HWND ListViewEstrellas::Crear(DBaseWnd *nPadre, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID) {
//    DListView::Crear(hWndPadre, cX, cY, cAncho, cAlto, cID, WS_CHILD | LVS_REPORT | WS_VISIBLE | WS_BORDER);
    DListView::Crear(nPadre, cX, cY, cAncho, cAlto, cID, WS_CHILD | LVS_REPORT | WS_VISIBLE | WS_BORDER, LVS_EX_DOUBLEBUFFER);
    AgregarColumna(TEXT("Texto"), 100);
    AgregarColumna(TEXT("Estrellas"), 100);
    _IconoEstrella.CargarIconoRecursos(IDI_ESTRELLA, 16, 16);
    _IconoEstrellaPalida.CargarIconoRecursos(IDI_ESTRELLA_PALIDA, 16, 16);
    return _hWnd;
}

// Suplanto la funcin AgregarItem por esta que solo permite 3 parametros
ItemEstrellas *ListViewEstrellas::AgregarItem(const int nIcono, const TCHAR *nTexto, const BYTE nEstrellas) {
    ItemEstrellas *NuevoItem = new ItemEstrellas(nEstrellas);
    DListView::AgregarItem(NuevoItem, nIcono, -1, -1, nTexto, TEXT(""));
    return NuevoItem;
};

// Suplanto la funcin Evento_PintarItem para pintar las estrellas en los subitems 1, en los demas subitems devuelvo CDRF_DODEFAULT para que se pinte el texto normalmente.
LRESULT ListViewEstrellas::Evento_PintarItem(HDC hDC, const UINT nItem, const UINT nSubItem, const DWORD nTipoItem) {
    if (nSubItem == 1) {
        RECT RI;
        ObtenerRectaTexto(nItem, nSubItem, RI);
        ItemEstrellas *TmpItem = static_cast<ItemEstrellas *>(_Items[nItem]);
        HICON nIcono = NULL;
        if (TmpItem->_EstrellasMM == -1) { // Normal
            for (char i = 0; i < TmpItem->Estrellas; i++) {
                DrawIconEx(hDC, RI.left + (i * 16), RI.top, _IconoEstrella(), 16, 16, 0, NULL, DI_NORMAL);
            }
        }
        else { // Mouse encima
            for (char i = 0; i < 5; i++) {
                DrawIconEx(hDC, RI.left + (i * 16), RI.top, _IconoEstrellaPalida(), 16, 16, 0, NULL, DI_NORMAL);
            }
            for (char i = 0; i < TmpItem->_EstrellasMM; i++) {
                DrawIconEx(hDC, RI.left + (i * 16), RI.top, _IconoEstrella(), 16, 16, 0, NULL, DI_NORMAL);
            }
        }
        return CDRF_SKIPDEFAULT;
    }
    return CDRF_DODEFAULT;
}

LRESULT ListViewEstrellas::Evento_Mouse_Movimiento(const int nItem, const int nSubItem, const int cX, const int cY) {
    // Normalizo el ultimo item
    if (_UltimoItem != -1) {
        static_cast<ItemEstrellas *>(_Items[_UltimoItem])->_EstrellasMM = -1;
        if (_UltimoItem != nItem) ListView_RedrawItems(_hWnd, _UltimoItem, _UltimoItem);
        //_RepintarItem(_Items[_UltimoItem]);
    }
    if (nSubItem == 1 && nItem != -1) {
        _UltimoItem = nItem;
        RECT RI;
        ObtenerRectaTexto(nItem, nSubItem, RI);
        int AnchoTmp = RI.left;
        ItemEstrellas *TmpItem = static_cast<ItemEstrellas *>(_Items[nItem]);
        TmpItem->_EstrellasMM = 0;
        while (AnchoTmp < cX) {
            AnchoTmp += 17;
            TmpItem->_EstrellasMM ++;
            if (TmpItem->_EstrellasMM == 5) break;
        }
        //_RepintarItem(_Items[nItem]);
        ListView_RedrawItems(_hWnd, nItem, nItem);
    }
    else {
        _UltimoItem = -1;
    }
    return 0;
}

LRESULT ListViewEstrellas::Evento_Mouse_Click(const int nItem, const int nSubItem, const UINT nBoton, const int cX, const int cY) {
    if (nSubItem == 1 && nItem != -1) {
        RECT RI;
        ObtenerRectaTexto(nItem, nSubItem, RI);
        int AnchoTmp = RI.left;
        ItemEstrellas *TmpItem = static_cast<ItemEstrellas *>(_Items[nItem]);
        TmpItem->Estrellas = 0;
        while (AnchoTmp < cX) {
            AnchoTmp += 17;
            TmpItem->Estrellas ++;
            if (TmpItem->Estrellas == 5) break;
        }
        //_RepintarItem(_Items[nItem]);
        ListView_RedrawItems(_hWnd, nItem, nItem);
    }
    return 0;
}

LRESULT ListViewEstrellas::Evento_Mouse_Saliendo(void) {
    if (_UltimoItem != -1) {
        RepintarItem(_UltimoItem);
        _UltimoItem = -1;
    }
    return 0;
}

